/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.Instances;
import weka.filters.AbstractFilterTest;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.NumericToBinary;

public class NumericToBinaryTest
extends AbstractFilterTest {
    public NumericToBinaryTest(String name) {
        super(name);
    }

    @Override
    public Filter getFilter() {
        NumericToBinary f = new NumericToBinary();
        return f;
    }

    public void testTypical() {
        Instances result = this.useFilter();
        NumericToBinaryTest.assertEquals(this.m_Instances.numAttributes(), result.numAttributes());
        NumericToBinaryTest.assertEquals(this.m_Instances.numInstances(), result.numInstances());
        int j = 0;
        while (j < result.numAttributes()) {
            if (this.m_Instances.attribute(j).isNumeric()) {
                NumericToBinaryTest.assertTrue("Numeric attribute should now be nominal", result.attribute(j).isNominal());
                int i = 0;
                while (i < result.numInstances()) {
                    if (this.m_Instances.instance(i).isMissing(j)) {
                        NumericToBinaryTest.assertTrue(result.instance(i).isMissing(j));
                    } else if (this.m_Instances.instance(i).value(j) == 0.0) {
                        NumericToBinaryTest.assertTrue("Output value should be 0", result.instance(i).value(j) == 0.0);
                    } else {
                        NumericToBinaryTest.assertTrue("Output value should be 1", result.instance(i).value(j) == 1.0);
                    }
                    ++i;
                }
            }
            ++j;
        }
    }

    public static Test suite() {
        return new TestSuite(NumericToBinaryTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run(NumericToBinaryTest.suite());
    }
}

